// Call the dataTables jQuery plugin
$(document).ready(function() {
    //$(document).find('.lds-hourglass').removeClass('.doNotShow')
    $.ajax({
        'url': base_url+"/api/fetchRequests",
        'method': "GET",
        'headers':{
            "Authorization": "Bearer "+sessionStorage.getItem('auth-token')
        },
        'contentType': 'application/json'
    }).done( function(data) {
        console.log(data)
        // sessionStorage.setItem('request-detail', data.requests);
        $('.lds-hourglass').addClass('doNotShow')
        if(data.requests){
            let hlt = 0;
            $('#dataTable').DataTable({
                "aaData": data.requests,
                "ordering":false,
                "columns": [
                    { "data": "request_id" },
                    { "data": "pick_up_address" },
                    { "data": "receiver_address" },
                    {
                        sortable: false,
                        "data": "delivery_status",
                        "render": function ( data, type, row, meta ) {
                            var status = ((parseInt(data)+1)/4)*100;
                            return "<div class='h5 mb-0 mr-3 font-weight-bold text-gray-800 progress-today-text'>"+status+"%</div>\
                                <div class='progress progress-sm mr-2'>\
                                    <div class='progress-bar bg-info percentage-progress-today' role='progressbar' style='width: "+status+"%' aria-valuenow='"+status+"' aria-valuemin='0' aria-valuemax='100'></div>\
                                </div>";
                        }
                    },
                    { "data": "items" },
                    // { "data": "date.normal, date.human" },
                    {
                        "data":"cancellation",
                        "render": function (data, type, row, meta) {
                            let health = data;
                            return (health == 1) ? "<i class='fas fa-times' style='color: red'></i> <i style='color: red'>Cancelled</i>" : "<i class='fas fa-check' style='color: green'></i>"
                        }
                    },
                    {
                        sortable: false,
                        "data": "date",
                        "render": function ( data, type, row, meta ) {
                            var date = data;
                            return "<div>"+date.normal+"</div>\
                                    <div>"+date.human+"</div>";
                        }
                    },
                    {
                        sortable: false,
                        "data": "actionarea",
                        "render": function ( data, type, row, meta ) {
                            return  (data.health == 0) ? "<button class='btn btn-sm btn-success editRequest' data-id='"+data.id+"'>Edit</button> <button class='btn btn-sm btn-primary viewRequestDetails' data-id='"+data.id+"'>View details</button> <button class='btn btn-sm btn-outline-danger cancelRequest' data-id='"+data.id+"'>Cancel Request</button>":"<button class='btn btn-sm btn-success editRequest' data-id='"+data.id+"'>Edit</button> <button class='btn btn-sm btn-primary viewRequestDetails' data-id='"+data.id+"'>View details</button>";
                        }
                    }
                ]
            })
        }else if(data.message == "Give user the login interface to login"){
            sessionStorage.clear();
            location.href = "/"
        }
    }).fail(function (data, textStatus, xhr) {
        Swal.fire(
            'Session Timeout!',
            'Logging you out',
            'error'
        )
        sessionStorage.clear();
        location.href = "/"
    });
});
/*
function populateDataTable(data) {
    console.log("populating data table...");
    // clear the table before populating it with more data
    $("#example").DataTable().clear();
    var length = Object.keys(data.customers).length;
    for(var i = 1; i < length+1; i++) {
        var customer = data.customers['customer'+i];

        // You could also use an ajax property on the data table initialization
        $('#example').DataTable().fnAddData( [
            customer.first_name,
            customer.last_name,
            customer.occupation,
            customer.email_address
        ]);
    }
}*/

