// Call the dataTables jQuery plugin
$(document).ready(function() {
    //$(document).find('.lds-hourglass').removeClass('.doNotShow')
    $.ajax({
        'url': base_url+"/api/fetchDrivers",
        'method': "GET",
        'headers':{
            "Authorization": "Bearer "+sessionStorage.getItem('auth-token')
        },
        'contentType': 'application/json'
    }).done( function(data) {
        console.log(data)
        // sessionStorage.setItem('request-detail', data.requests);
        if(data.success){
            let hk = data.drivers
            $('.lds-hourglass').addClass('doNotShow')
            $('#dataTable').DataTable({
                "aaData": data.drivers,
                "ordering":false,
                "columns": [
                    {
                        "data": "id",
                        "render": function ( data, type, row, meta ) {
                            return "<p>00"+data+"</p>";
                        }
                    },
                    { "data": "firstname" },
                    { "data": "lastname" },
                    { "data": "email" },
                    { "data": "phone_number"},
                    /*{
                        sortable: false,
                        "data": "delivery_status",
                        "render": function ( data, type, row, meta ) {
                            var status = ((parseInt(data)+1)/4)*100;
                            return "<div class='h5 mb-0 mr-3 font-weight-bold text-gray-800 progress-today-text'>"+status+"%</div>\
                                <div class='progress progress-sm mr-2'>\
                                    <div class='progress-bar bg-info percentage-progress-today' role='progressbar' style='width: "+status+"%' aria-valuenow='"+status+"' aria-valuemin='0' aria-valuemax='100'></div>\
                                </div>";
                        }
                    },*/
                    {
                        "data": "driver",
                        "render": function (data, type, row, meta) {
                            var checkIfNull = (data != null) ? '<p>'+(data.plate_number != null ? data.plate_number : "<i>Not set</i>")+'</p>' : ''
                            return checkIfNull;
                        }
                    },
                    {
                        "data": "driver",
                        "render": function (data, type, row, meta) {
                            var checkIfNull = (data != null) ? '<p>'+(data.photo != null ? data.plate_number : '<i>Not set</i>')+'</p>' : ''
                            return checkIfNull;
                        }
                    },

                    {
                        sortable: false,
                        "data": "action",
                        "render": function ( data, type, row, meta) {
                            return "<button class='btn btn-sm btn-success editDriver' data-id='"+data.id+"'>Edit</button>"+ (data.active == 1 ? " <button class='btn btn-sm btn-danger banDriver' data-id='"+data.id+"'>Ban</button>":" <button class='btn btn-sm btn-warning unbanDriver' data-id='"+data.id+"'>UnBan</button>");
                        }
                    }
                ]
            })
        }

    })
});


